;----------------------------------------------------------------------------
;    MODULE NAME:   TryMeCreateMergeModule.MM
;
;        $Author:   USER "Dennis"  $
;      $Revision:   1.0  $
;          $Date:   29 Nov 2006 18:31:54  $
;       $Logfile:   C:/DBAREIS/Projects.PVCS/Win32/MakeMsi/TryMeCreateMergeModule.mm.pvcs  $
;
; DESCRIPTION
; ~~~~~~~~~~~
; A same/test merge module you can use the created MSI via the
; sample "TryMeUseMergeModule.MM".
;
; Note that almost every merge module I have ever seen has incorrectly
; defined "SystemFolder", "ProgramFilesFolder" etc, I have created the
; "MsmSystemDirectory" macro to make the correct definition of these
; childs play...
;
; You would probably wish to create all components yourself as the greater
; control you have is probably required.
;
; I don't create many merge modules (yet), if something is an issue then
; let me know and I'll come up with a way of making it easier.
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;--- Load MAKEMSI (via wrapper) ---------------------------------------------
;----------------------------------------------------------------------------
#include "MakeMsm.MMH"              ;;Load the merge module support


;----------------------------------------------------------------------------
;--- Correctly define "ProgramFilesFolder" (call it "PFF") ------------------
;----------------------------------------------------------------------------
<$MsmSystemDirectory "ProgramFilesFolder" KEYMAC="PFF">


;----------------------------------------------------------------------------
;--- Define installation directory (under "ProgramFilesFolder") -------------
;----------------------------------------------------------------------------
#define  INSTALLDIR  MyDir<$MsmSuffix>
#define+ AnyDir      <$INSTALLDIR>          ;;If MAKEMSI creates components for me, I don't want it to use "TARGETDIR"!
<$Directory Key="<$INSTALLDIR>" Parent="<$PFF>" Dir="MmTest">


;----------------------------------------------------------------------------
;--- Add a file to a component we create (fixed GUID) -----------------------
;----------------------------------------------------------------------------
#define AnyFileWillDo   <?InputFile>
<$Component "MyComp<$MsmSuffix>" Directory_="<$INSTALLDIR>" ComponentId=^?MyComp^ Attributes=^SharedDllRefCount Permanent^>
    <$File Source="<$AnyFileWillDo>" 8.3="NoClash.1">
<$/Component>


;----------------------------------------------------------------------------
;--- Add a file (let it create a component - GUID not fixed!) ---------------
;----------------------------------------------------------------------------
#define+ DEFAULT_COMPONENT_ATTRIBUTES SharedDllRefCount Permanent  ;;Another way to set attributes.
<$File Source="<$AnyFileWillDo>" Destination="[<$INSTALLDIR>]\ViaFileCreatedComponent.fcc">

;----------------------------------------------------------------------------
;--- Add a registry entry (let it create a component - GUID not fixed!) -----
;----------------------------------------------------------------------------
<$Registry HKEY="CURRENT_USER" Key="Software\DENNIS_ViaMm" Name='From <?InputFile>'  Value="Hi ya">

